/******************************************************************************/
#include "stdafx.h"
/******************************************************************************/
struct DisplayOptions
{
   Window   window;
   CheckBox vol, hp_rt, hdr;
   Text    tvol,thp_rt,thdr;
   
   void create()
   {
      Gui   +=window.create(Rect_R(D.w(),0.5,0.8,0.35),"Display options");
      window+=vol   .create(Rect (0.05,-0.10,0.10,-0.05)); window+=tvol  .create(Vec2(0.45,-0.075),"Volumetric Lighting");
      window+=hp_rt .create(Rect (0.05,-0.18,0.10,-0.13)); window+=thp_rt.create(Vec2(0.45,-0.155),"High Precision RenderTargets");
      window+=hdr   .create(Rect (0.05,-0.26,0.10,-0.21)); window+=thdr  .create(Vec2(0.45,-0.235),"High Dynamic Range");
   }
   void update()
   {
      D.volLight(vol  ());
      D.hpRt    (hp_rt());
      D.hdr     (hdr  ());
   }
}Opt;
/******************************************************************************/
struct CloudOptions
{
   Window    window;
   Slider    dns, shd, col0, col1,  scale, curve, height;
   Text     tdns,tshd,tcol0,tcol1, tscale,tcurve,theight;
   CheckBox  detail, hi_res, anim;
   Text     tdetail,thi_res,tanim;

   void create()
   {
      Gui+=window.create(Rect_RD(D.w(),-D.h(),0.6,0.77),"Clouds Options");

      window+=tdns  .create(Vec2(0.15,-0.05),"Density"); window+=dns .create(Rect_LU(0.3,-0.03,0.25,0.05), 3.0/6);
      window+=tshd  .create(Vec2(0.15,-0.10),"Shadow" ); window+=shd .create(Rect_LU(0.3,-0.08,0.25,0.05), 0.5  );
      window+=tcol0 .create(Vec2(0.15,-0.15),"Color0" ); window+=col0.create(Rect_LU(0.3,-0.13,0.25,0.05), 0.38 );
      window+=tcol1 .create(Vec2(0.15,-0.20),"Color1" ); window+=col1.create(Rect_LU(0.3,-0.18,0.25,0.05), 0.7  );

      window+=tscale .create(Vec2(0.15,-0.30),"Scale" ); window+=scale .create(Rect_LU(0.3,-0.28,0.25,0.05), 0.5);
      window+=tcurve .create(Vec2(0.15,-0.35),"Curve" ); window+=curve .create(Rect_LU(0.3,-0.33,0.25,0.05), 0.5);
      window+=theight.create(Vec2(0.15,-0.40),"Height"); window+=height.create(Rect_LU(0.3,-0.38,0.25,0.05), 0.5);

      window+=tdetail.create(Vec2(0.20,-0.50),"Detail"         ); window+=detail.create(Rect(0.40,-0.53,0.45,-0.48));
      window+=thi_res.create(Vec2(0.20,-0.57),"High Resolution"); window+=hi_res.create(Rect(0.40,-0.60,0.45,-0.55));
      window+=tanim  .create(Vec2(0.20,-0.64),"Animate"        ); window+=anim  .create(Rect(0.40,-0.67,0.45,-0.62));
   }
   void cloudsToGui()
   {
      dns .set(Clouds.volumetric.density/6);
      shd .set(Clouds.volumetric.shadow);
      col0.set(Clouds.volumetric.dark_color  .avg());
      col1.set(Clouds.volumetric.bright_color.avg());

      scale .set(LerpR(0.125f,0.375f,Clouds.volumetric.c.scale ));
      curve .set(LerpR(0.000f,0.060f,Clouds.volumetric.c.curve ));
      height.set(LerpR(0.000f,1.540f,Clouds.volumetric.c.height));

      detail.set( Clouds.volumetric.detail!=NULL);
      hi_res.set( Clouds.volumetric.hi_res);
      anim  .set((Clouds.volumetric.animate&VOL_CLOUDS_ANIM_CLOUDS) ? true : false);
   }
   void guiToClouds()
   {
      Clouds.volumetric.density=Lerp(0,6,dns());
      Clouds.volumetric.shadow =Lerp(0,1,shd());
      Clouds.volumetric.dark_color  .set(col0());
      Clouds.volumetric.bright_color.set(col1());

      Clouds.volumetric.c.scale =Lerp(0.125f,0.375f,scale ());
      Clouds.volumetric.c.curve =Lerp(0.000f,0.060f,curve ());
      Clouds.volumetric.c.height=Lerp(0.000f,1.540f,height());

      Clouds.volumetric.detail =(detail() ? Gfxs("Clouds/Volumetric/detail.gfx") : NULL);
      Clouds.volumetric.hi_res = hi_res() ;
      Clouds.volumetric.animate=(anim  () ? VOL_CLOUDS_ANIM_CLOUDS : 0);
   }
}Co;
/******************************************************************************/
struct CloudGenerate
{
   Window window;
   Button generate,generate8,load,save;

   static void Generate(Ptr user)
   {
      Clouds.volumetric.create(UInt(user),DIRF_RIGHT|DIRF_DOWN|DIRF_FORWARD,80); // create new ones with 'user' animation frames, right down forward light direction, and 80 random clouds
      Tm    .skipUpdate();                                                       // generating clouds is slow, so don't update timer in this frame
   }
   static void Load(Ptr){if(Clouds.volumetric.load("Data/clouds"))Co.cloudsToGui();}
   static void Save(Ptr){   Clouds.volumetric.save("Data/clouds")                 ;}
   void create()
   {
      Gui   +=window   .create(Rect_LD(-D.w(),-D.h(),0.65,0.45),"Clouds Generate");
      window+=generate .create(Rect_C (window.rect.w()  /2,-0.08,0.35,0.06),"Generate"         ,Generate,Ptr(1));
      window+=generate8.create(Rect_C (window.rect.w()  /2,-0.18,0.45,0.06),"Generate Animated",Generate,Ptr(8));
      window+=load     .create(Rect_C (window.rect.w()*1/3,-0.28,0.18,0.06),"Load"             ,Load);
      window+=save     .create(Rect_C (window.rect.w()*2/3,-0.28,0.18,0.06),"Save"             ,Save);
   }
}Cg;
/******************************************************************************/
Mshg terrain;
/******************************************************************************/
void InitPre()
{
   App.name="Volumetric Clouds";
   App.flag=APP_FULL_TOGGLE;
   IOPath="../data/";
   PakAdd("engine.pak");

   D.full(true).ambPower(0.3).hdrExposure(0.7);
}
Bool Init()
{
   terrain.load("obj/terrain/0.mshg"); // terrain
   Sun.set(*Gfxs("gfx/sky/sun.gfx"));  // sun
   Sky.set();                          // sky

   // gui
   Opt.create();
   Cg .create();
   Co .create();
   return true;
}
void Shut()
{
}
/******************************************************************************/
Bool Main()
{
   if(Kb.bp(KB_ESC))return false;
   CamHandle(0.01,500,Ms.hidden ? CAMH_ZOOM|(Ms.b(1)?CAMH_MOVE:CAMH_ROT) : 0); // when mouse hidden operate the camera

   if(Kb.bp(KB_TAB))
   {
      Ms .              toggle(); // toggle mouse visibility when tab pressed
      Opt.window.visibleToggle();
      Cg .window.visibleToggle();
      Co .window.visibleToggle();
   }

   Gui.update();
   Opt.update();
   Co .guiToClouds();

   if(Kb.bp(KB_F10))Renderer.screenShots("screenshot/%d.bmp");
   if(Kb.bp(KB_F11))D       .toggle();

   if(!Kb.b(KB_SPACE))Clouds.volumetric.update(Vec2(4,4)); // if space not pressed then update clouds position by given velocity

   return true;
}
/******************************************************************************/
void Render()
{
   switch(Renderer())
   {
      case RM_SOLID:
         terrain.draw();
      break;
   }
}
void Draw()
{
   Renderer(Render);
   Gui.draw();
   D.text(0,0.9,S+"Fps "+Tm.fps);
   D.text(0,0.8,Ms.hidden ? "Press Tab to toggle parameters" : "Press Tab to operate the camera");
}
/******************************************************************************/
